<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FieldValueLanguage extends Model 
{

    protected $table = 'lim_field_value_languages';
    public $timestamps = true;
    protected $fillable = array('lim_language_id', 'lim_field_value_id', 'value');
    protected $visible = array('lim_language_id', 'lim_field_value_id', 'value');

    public function language()
    {
        return $this->belongsTo('App\Models\Language', 'lim_language_id');
    }

    public function value()
    {
        return $this->belongsTo('App\Models\FieldValues', 'lim_field_value_id');
    }

}